//
//  FJDItemsInFolderWindowController.m
//  FJDItemsInFolderWindow
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FJDItemsInFolderWindowController.h"
#import "FJDSortedArrayController.h"


@implementation FJDItemsInFolderWindowController


#pragma mark Methods overriding superclass

- (void)windowDidLoad
{
	NSSortDescriptor *orderSortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"order" ascending:YES];
	NSSortDescriptor *folderSortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"folder.order" ascending:YES];

	NSArray *sortDescriptorsForFolders = [NSArray arrayWithObject:orderSortDescriptor];
	NSArray *sortDescriptorsForItems = [NSArray arrayWithObjects:folderSortDescriptor, orderSortDescriptor, nil];
	
	[orderSortDescriptor release];
	[folderSortDescriptor release];

	[itemsController setDefaultSortDescriptors:sortDescriptorsForItems];
	[foldersController setDefaultSortDescriptors:sortDescriptorsForFolders];
	
	[itemsController setValue:@"order" forKey:@"indexKeyPath"];
	[foldersController setValue:@"order" forKey:@"indexKeyPath"];
}

#pragma mark Accessor methods

- (NSString *)localizedItemName
{
	return NSLocalizedStringFromTable(@"item", @"CoreDataLocalizable", @"itemName");
}

- (NSString *)localizedPluralItemName
{
	return NSLocalizedStringFromTable(@"items", @"CoreDataLocalizable", @"pluralItemName");
}

- (NSString *)localizedFolderName
{
	return NSLocalizedStringFromTable(@"folder", @"CoreDataLocalizable", @"folderName");
}

- (NSString *)localizedPluralFolderName;
{
	return NSLocalizedStringFromTable(@"folders", @"CoreDataLocalizable", @"pluralFolderName");
}


@end
